@extends('layouts.master')

@section('extra_css')
    @if($settings_general->site_post_as_titles == 1)
        <title>{{$post->title}}</title>
    @else
        <title>{{$settings_general->site_title}}</title>
    @endif

    @if(sizeof($post->tags) > 0)
        <meta name="keywords" content="{{implode(',',$post->tags->lists('title')->toArray())}}">
    @endif

    <meta name="description" content="{{\Illuminate\Support\Str::limit(trim(strip_tags($post->description)),300)}}">

    <!--Twitter Card-->
    <meta property="twitter:card" content="summary"/>
    <meta property="twitter:site" content="{{$settings_social->twitter_handle}}"/>
    <meta property="twitter:title" content="{{$post->title}}"/>
    <meta property="twitter:description" content="{{\Illuminate\Support\Str::limit(trim(strip_tags($post->description)),300)}}"/>
    <meta property="twitter:image" content="{{$post->featured_image}}"/>
    <meta name="twitter:creator" content="{{$settings_social->twitter_handle}}">
    <meta property="twitter:url" content="{{URL::to($post->slug)}}"/>

    <!--Og tags-->
    <meta property="og:site_name" content="{{$settings_general->site_title}}"/>
    <meta property="og:title" content="{{$post->title}}"/>
    <meta property="og:description" content="{{\Illuminate\Support\Str::limit(trim(strip_tags($post->description)),300)}}"/>
    <meta property="og:type" content="article"/>
    <meta property="og:url" content="{{URL::to($post->slug)}}"/>
    <meta property="og:image" content="{{$post->featured_image}}"/>

    @foreach($related_posts as $r)
        <meta property="og:see_also" content="{{URL::to($r->slug)}}"/>
    @endforeach

    <meta property="article:published_time" content="{{$post->created_at}}"/>
    <meta property="article:modified_time" content="{{$post->updated_at}}"/>

    @foreach($post->tags as $tag)
        <meta property="article:tag" content="{{$tag->title}}"/>
    @endforeach

@stop

@section('extra_js')
    @if(strlen($settings_social->addthis_js) > 0 && $settings_social->show_sharing == 1)
        {!! $settings_social->addthis_js !!}
    @endif

    @if(strlen($settings_social->sharethis_js) > 0 && $settings_social->show_sharing == 1)
        {!! $settings_social->sharethis_js !!}
    @endif

    @if($settings_comments->comment_system == \App\Posts::COMMENT_FACEBOOK)
        {!! $settings_comments->fb_js !!}
    @endif

@stop

@section('content')

    @if($post->image_parallax == 1 && $post->render_type == \App\Posts::RENDER_TYPE_IMAGE)
        <div class="parallax-header">

            <!-- Parallax image -->
            <div class="parallax-image" id="parallax-image" data-stellar-ratio="0.5"
                 data-image="{{$post->featured_image}}"></div>

            <!-- Post title and meta -->
            <div class="parallax-wrapper">
                <div class="container">
                    <div class="mag-content parallax-box">
                        <div class="row">
                            <div class="col-md-12 parallax-box">
                                @include('layouts.post_header')
                            </div>
                            <!-- .col-md-12 -->
                        </div>
                        <!-- .row -->
                    </div>
                </div>
                <!-- .container -->

            </div>
            <!-- .parallax-wrapper -->
        </div>
    @endif

    <div class="container main-wrapper">

        @if(!empty($ads[\App\Ads::TYPE_ABOVE_POST]))
            <div class="mag-content clearfix">
                <div class="row">
                    <div class="col-md-12">
                        <div class="ad728-wrapper">

                            {!! $ads[\App\Ads::TYPE_ABOVE_POST]->code !!}

                        </div>
                    </div>
                </div>
            </div>
        @endif


        <div class="main-content mag-content clearfix">

            <div class="row blog-content">

                <div class="col-md-8">

                    @include('admin.layouts.notify')

                    <article class="post-wrapper clearfix">

                        @if($post->render_type == \App\Posts::RENDER_TYPE_IMAGE)
                            @include('layouts.post_header')
                        @endif

                        @if($post->render_type == \App\Posts::RENDER_TYPE_GALLERY)
                            @include('layouts.post_header')
                        @endif

                        @if($post->render_type == \App\Posts::RENDER_TYPE_VIDEO)
                            @include('layouts.post_header')
                        @endif

                        @if($post->render_type == \App\Posts::RENDER_TYPE_TEXT)
                            @include('layouts.post_header')
                        @endif

                        @if($post->rating_box == 1)
                            <div class="post-review-wrapper clearfix">
                                <div class="post-review-summary clearfix">
                                    <div class="post-review-sum-point">
                                        <h4 id="rate_target">{{\App\Libraries\Utils::doubleTruncate($post->average_rating,1)}}</h4>
                   <span class="article_raty"
                         data-score="{{\App\Libraries\Utils::doubleTruncate($post->average_rating,1)}}"></span>

                                        <p style="text-align: center;">
                                            <small>({{$post->rating_count}}) Reviews</small>
                                        </p>

                                        <p>
                                            <button type="button" class="btn btn-primary" data-toggle="modal"
                                                    data-target="#rate_me">
                                                Rate Now
                                            </button>
                                        </p>

                                    </div>
                                    <div class="post-review-description">
                                        <div class="post-content clearfix">{!! $post->description !!}</div>
                                    </div>
                                </div>

                            </div>
                        @else
                            <div class="post-content clearfix">{!! $post->description !!}</div>
                        @endif

                        @if($post->type == \App\Posts::TYPE_SOURCE)
                            <a href="{{$post->link}}" type="button" class="pull-right btn btn-success btn-lg">Read
                                more</a>
                        @endif


                        @if($post->rating_box == 1)
                            <div class="modal fade" id="rate_me" tabindex="-1" role="dialog"
                                 aria-labelledby="review-modalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">&times;</button>
                                            <h4 class="modal-title" id="review-modalLabel">Rate this article:</h4>
                                        </div>
                                        <div class="modal-body">

                                            <form action="/submit_rating" method="POST">

                                                <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                                                <input type="hidden" name="id" value="{{$post->id}}"/>

                                                <div class="form-group form-group-rating">
                                                    <div class="rating-label">
                                                        <p><strong>How do you rate this article ?</strong></p>
                                                    </div>
                                                    <div class="clearfix"></div>
                                                    <div id="ratyRating"></div>
                                                    <div class="clearfix"></div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="rate_name">Please enter your name</label>
                                                    <input class="form-control" name="name" id="rate_name"/>
                                                </div>

                                                <div class="form-group">
                                                    <label for="rate_email">Please enter your email</label>
                                                    <input class="form-control" name="email" id="rate_email"/>
                                                </div>

                                                <div class="review-actions">
                                                    <button type="submit" class="btn btn-success"><strong>Submit
                                                            Rating</strong></button>
                                                </div>

                                            </form>


                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <footer class="post-meta">
                            <div class="tags-wrapper">
                                <ul class="tags-widget clearfix">
                                    <li class="trending">TAGS:</li>
                                    @foreach($post->tags as $tag)
                                        <li><a href="/tag/{{$tag->slug}}">{{$tag->title}}</a></li>
                                    @endforeach
                                </ul>
                            </div>
                            <!-- .tags-wrapper -->

                            <div class="share-wrapper clearfix">
                                @if(strlen($settings_social->addthis_js) > 0 && $settings_social->show_sharing == 1)
                                    <div class="addthis_sharing_toolbox"></div>
                                @endif

                                @if(strlen($settings_social->sharethis_span_tags) > 0 && strlen($settings_social->sharethis_js) > 0 && $settings_social->show_sharing == 1)
                                    {!! $settings_social->sharethis_span_tags !!}
                                @endif
                            </div>

                            <div class="row">
                                <div class="post-nav-wrapper clearfix">
                                    <div class="col-md-6 omega">
                                        <div class="previous-post">
                                            <div class="post-nav-label">
                                                <i class="fa fa-angle-left"></i>
                                                Previous post
                                            </div>
                                            @if(!empty($post->prev))
                                                <a href="/{{$post->prev->slug}}"
                                                   class="post-nav-title">{{$post->prev->title}}</a>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-md-6 alpha">
                                        <div class="next-post">
                                            <div class="post-nav-label">
                                                Next post
                                                <i class="fa fa-angle-right"></i>
                                            </div>
                                            @if(!empty($post->next))
                                                <a href="/{{$post->next->slug}}"
                                                   class="post-nav-title">{{$post->next->title}}</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <!-- .post-nav-wrapper -->
                            </div>

                            @if($post->show_author_box == 1)
                                <div class="author-box clearfix">
                                    <div class="author-avatar">
                                        <a href="/author/{{$post->author->slug}}">
                                            <img alt="" src="{{$post->author->avatar}}" class="avatar"
                                                 height="110"
                                                 width="110">
                                        </a>
                                    </div>
                                    <div class="author-info">
                                        <h3><a href="/author/{{$post->author->slug}}">{{$post->author->name}}</a></h3>

                                        <p class="author-bio">
                                            {{$post->author->bio}}
                                        </p>

                                        @if($post->show_author_socials == 1)
                                            <div class="author-contact">
                                                @if(strlen($post->author->email)>0)
                                                    <a href="mailto:{{$post->author->email}}"><i
                                                                class="fa fa-envelope fa-lg"
                                                                title="Email"></i></a>
                                                @endif
                                                @if(strlen($post->author->website_url)>0)
                                                    <a href="{{$post->author->website_url}}" target="_blank"><i
                                                                class="fa fa-globe fa-lg"
                                                                title="Website"></i></a>
                                                @endif

                                                @if(strlen($post->author->fb_url)>0)
                                                    <a href="{{$post->author->fb_url}}" target="_blank"><i
                                                                class="fa fa-facebook fa-lg"
                                                                title="Facebook"></i></a>
                                                @endif

                                                @if(strlen($post->author->twitter_url)>0)
                                                    <a href="{{$post->author->twitter_url}}" target="_blank"><i
                                                                class="fa fa-twitter fa-lg"
                                                                title="Twitter"></i></a>
                                                @endif

                                                @if(strlen($post->author->google_plus_url)>0)
                                                    <a href="{{$post->author->google_plus_url}}" rel="publisher"
                                                       target="_blank"><i title="Google+"
                                                                          class="fa fa-google-plus fa-lg"></i></a>
                                                @endif

                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        </footer>

                    </article>

                    @if(sizeof($related_posts) > 0)
                        <div class="related-posts clearfix">
                            <h3 class="block-title"><span>Related Posts</span></h3>

                            <div class="row">
                                @foreach($related_posts as $post)
                                    <div class="col-md-6">
                                        <article class="news-block small-block">
                                            <a href="/{{$post->slug}}" class="overlay-link">
                                                @if($post->render_type == \App\Posts::RENDER_TYPE_IMAGE)
                                                    <figure class="image-overlay">
                                                        <img src="{{$post->featured_image}}" alt="">
                                                    </figure>
                                                @else
                                                    {{$post->video_embed_code}}
                                                @endif
                                            </a>
                                            <a href="/category/{{$post->category->slug}}/{{$post->sub_category->slug}}"
                                               class="category">
                                                {{$post->sub_category->title}}
                                            </a>
                                            <header class="news-details">
                                                <h3 class="news-title">
                                                    <a href="/{{$post->slug}}">
                                                        {{$post->title}}
                                                    </a>
                                                </h3>

                                                <p class="simple-share">
                                                    by
                                                    <a href="/author/{{$post->author->slug}}"><b>{{$post->author->name}}</b></a>
                                                    -
                                                <span class="article-date"><i
                                                            class="fa fa-clock-o"></i> {{$post->created_at->diffForHumans()}}</span>
                                                </p>
                                            </header>
                                        </article>
                                    </div>
                                @endforeach
                            </div>

                        </div>
                    @endif

                    @if(!empty($ads[\App\Ads::TYPE_BELOW_POST]))
                        <div class="row">
                            <div class="col-md-12">
                                {!! $ads[\App\Ads::TYPE_BELOW_POST]->code !!}
                            </div>
                        </div>
                    @endif

                    @if($settings_comments->comment_system == \App\Posts::COMMENT_DISQUS)
                        <div id="comments" class="comments-wrapper clearfix">
                            <h3 class="block-title"><span>Comments</span></h3>

                            {!! $settings_comments->disqus_js !!}

                        </div>
                    @endif

                    @if($settings_comments->comment_system == \App\Posts::COMMENT_FACEBOOK)
                        <div id="comments" class="comments-wrapper clearfix">
                            <h3 class="block-title"><span>Comments</span></h3>

                            <div class="fb-comments" data-href="{{URL::full()}}"
                                 data-numposts="{{empty($settings_comments->fb_num_posts)?5:$settings_comments->fb_num_posts}}"></div>

                        </div>
                    @endif


                </div>

                <div class="col-md-4">
                    @include('layouts.sidebar')
                </div>
            </div>

        </div>
    </div>
@stop

